// COPYRIGHT:      &copy; BSOT

#ifndef __SPI_TCLMYSPINAUDIOGSTREAMER_H__
#define __SPI_TCLMYSPINAUDIOGSTREAMER_H__

#include "mspin_audio_stream.h"
#include "mspin_logging.h"
#include "spi_tclMySpinAudioGstreamerInternal.h"


#include <signal.h>                 //signal
#include <stdlib.h>                 //EXIT_SUCCESS
#include <gst/gst.h>                //Gst
#include <gst/app/gstappsrc.h>      // appsrc
#include <string.h>                 // strcmp, ...
#include <unistd.h>
#include <fcntl.h>                  // O_RDONLY | O_NONBLOCK
#include <sched.h>


typedef struct player
{
    GstElement* audiosink;
    GstElement* audiosrc;

    GstElement* sbcdec;
    GstElement* queue;
    GstElement* volume;
    GstElement* capsfilter;
    GstElement* pipeline;

    GMainLoop* loop;
    GstBus*    bus;

    guint sourceid;
    gint  file;
} Player;


class spi_tclMySpinAudioGstreamerInternal;

class spi_tclMySpinAudioGstreamer
{
public:
    static player gPlay;
    static pthread_t gAudioPlayThread;
    static char* gAudioSrc;
    static char* gAudioSink;
    static bool gAudioPlaying;
    static bool gFlushAfterEosNeeded;

    static audioStreamConfig gAudioStreamConfig;
    static audioStreamDeviceType gStreamDeviceType;
    static audioStreamCallbacks gAudioStreamCallbacks;


    spi_tclMySpinAudioGstreamer();
    ~spi_tclMySpinAudioGstreamer();

    void mspin_audio_stop(void);
    int mspin_audio_start(const char *audiosrc, const char *audiosink, audioStreamDeviceType stream_dev_type);

    void mspin_audio_set_config(audioStreamConfig config);
    void mspin_audio_set_rate(U32 rate);
    void mspin_audio_register_callbacks(U32 cou32Context , audioStreamCallbacks rAudioStreamCallbacks);
    void mspin_audio_handle_rate_changed(U32 u32SampleRate);

    static gboolean mspin_audio_busCall(GstBus *bus, GstMessage *msg, gpointer data);
    static int mspin_audio_create_pipeline_alsasrc_alsasink(const char *const copocAudioSrc , const char *const copocAudioSink ,
                                                   const char *f_pEncoding, int f_iSampleRate,
                                                   int f_iChannels, int f_iSampleWidth,
                                                   int f_iSampleDepth, bool f_bSigned,
                                                   bool f_bEndianness);
};

#endif /* __SPI_TCLMYSPINAUDIOGSTREAMER_H__ */
